﻿function SimpleBar:InitOptions()
	local title, sub = self:MakeTitleTextAndSubText('SimpleBar', 'These options allow you to customize the looks of SimpleBar.')
	local vStep = -22
	local vOfs = 0

	self:MakeToggle(
		'name', 'Hide micromenu',
		'description', '',
		'default', false,
		'current', SimpleBar.db.char.microMenuHidden,
		'setFunc', function(value)
			SimpleBar:HideMicromenu(value)
		end
	):SetPoint('TOPLEFT', sub, 'BOTTOMLEFT', 0, vOfs + vStep * 1) 	
	
	self:MakeToggle(
		'name', 'Hide bags',
		'description', '',
		'default', false,
		'current', SimpleBar.db.char.bagsBarHidden,
		'setFunc', function(value)
			SimpleBar:HideBagsBar(value)
		end
	):SetPoint('TOPLEFT', sub, 'BOTTOMLEFT', 0, vOfs + vStep * 2)

	self:MakeToggle(
		'name', 'Hide gryphons',
		'description', '',
		'default', false,
		'current', SimpleBar.db.char.mainBarGryphonsHidden,
		'setFunc', function(value)
			SimpleBar:HideGryphons(value)
		end
	):SetPoint('TOPLEFT', sub, 'BOTTOMLEFT', 0, vOfs + vStep * 3)
	
	self:MakeToggle(
		'name', 'Hide pet actionbar',
		'description', '',
		'default', false,
		'current', SimpleBar.db.char.petBarHidden,
		'setFunc', function(value)
			SimpleBar:HidePetBar(value)
		end
	):SetPoint('TOPLEFT', sub, 'BOTTOMLEFT', 160, vOfs + vStep * 1) 	
	
	self:MakeToggle(
		'name', 'Hide shapeshift/bonus actionbar',
		'description', '',
		'default', false,
		'current', SimpleBar.db.char.bonusBarHidden,
		'setFunc', function(value)
			SimpleBar:HideBonusBar(value)
		end
	):SetPoint('TOPLEFT', sub, 'BOTTOMLEFT', 160, vOfs + vStep * 2)
	
	vOfs = vOfs + vStep * 4
	
	self:MakeToggle(
		'name', 'Lock micromenu',
		'description', '',
		'default', false,
		'current', SimpleBar.db.char.microMenuLocked,
		'setFunc', function(value)
			SimpleBar:LockMicromenu(value) 
		end
	):SetPoint('TOPLEFT', sub, 'BOTTOMLEFT', 0, vOfs + vStep * 1)
	
	self:MakeToggle(
		'name', 'Lock bags',
		'description', '',
		'default', false,
		'current', SimpleBar.db.char.bagsBarLocked,
		'setFunc', function(value)
			SimpleBar:LockBagsBar(value) 
		end
	):SetPoint('TOPLEFT', sub, 'BOTTOMLEFT', 0, vOfs + vStep * 2) 	
	
	self:MakeToggle(
		'name', 'Lock pet actionbar',
		'description', '',
		'default', false,
		'current', SimpleBar.db.char.petBarLocked,
		'setFunc', function(value)
			SimpleBar:LockPetBar(value) 
		end
	):SetPoint('TOPLEFT', sub, 'BOTTOMLEFT', 160, vOfs + vStep * 1)	
	
	self:MakeToggle(
		'name', 'Lock shapeshift/totem actionbar',
		'description', '',
		'default', false,
		'current', SimpleBar.db.char.bonusBarLocked,
		'setFunc', function(value)
			SimpleBar:LockBonusBar(value) 
		end
	):SetPoint('TOPLEFT', sub, 'BOTTOMLEFT', 160, vOfs + vStep * 2)	
	
	vOfs = vOfs + vStep * 2
	vStep = -50

	self:MakeSlider(
		'name', 'Scale All',
		'description', '',
		'minText', '0.5',
		'maxText', '1.5',
		'minValue', 0.5,
		'maxValue', 1.5,
		'step', 0.05,
		'default', 1,
		'current', SimpleBar.db.char.mainBarScale,
		'setFunc', function(value) 
			SimpleBar:ScaleMainMenuBar(value)	
		end,
		'currentTextFunc', function(value) 
			return ("%.2f"):format(value) 
		end
	):SetPoint('TOPLEFT', sub, 'BOTTOMLEFT', 0, vOfs + vStep * 1)
	
	self:MakeSlider(
		'name', 'Scale micromenu',
		'description', '',
		'minText', '0.5',
		'maxText', '1.5',
		'minValue', 0.5,
		'maxValue', 1.5,
		'step', 0.05,
		'default', 1,
		'current', SimpleBar.db.char.microMenuScale,
		'setFunc', function(value) 
			SimpleBar:ScaleMicromenu(value)	
		end,
		'currentTextFunc', function(value) 
			return ("%.2f"):format(value) 
		end
	):SetPoint('TOPLEFT', sub, 'BOTTOMLEFT', 0, vOfs + vStep * 2)

	self:MakeSlider(
		'name', 'Scale pet actionbar',
		'description', '',
		'minText', '0.5',
		'maxText', '1.5',
		'minValue', 0.5,
		'maxValue', 1.5,
		'step', 0.05,
		'default', 1,
		'current', SimpleBar.db.char.petBarScale,
		'setFunc', function(value) 
			SimpleBar:ScalePetBar(value)	
		end,
		'currentTextFunc', function(value) 
			return ("%.2f"):format(value) 
		end
	):SetPoint('TOPLEFT', sub, 'BOTTOMLEFT', 200, vOfs + vStep * 2)	
	
	self:MakeSlider(
		'name', 'Scale bags',
		'description', '',
		'minText', '0.5',
		'maxText', '1.5',
		'minValue', 0.5,
		'maxValue', 1.5,
		'step', 0.05,
		'default', 1,
		'current', SimpleBar.db.char.bagsBarScale,
		'setFunc', function(value) 
			SimpleBar:ScaleBagsBar(value)	
		end,
		'currentTextFunc', function(value) 
			return ("%.2f"):format(value) 
		end
	):SetPoint('TOPLEFT', sub, 'BOTTOMLEFT', 0, vOfs + vStep * 3)	
	
	self:MakeSlider(
		'name', 'Scale shapeshift/totem actionbar',
		'description', '',
		'minText', '0.5',
		'maxText', '1.5',
		'minValue', 0.5,
		'maxValue', 1.5,
		'step', 0.05,
		'default', 1,
		'current', SimpleBar.db.char.bonusBarScale,
		'setFunc', function(value) 
			SimpleBar:ScaleBonusBar(value)	
		end,
		'currentTextFunc', function(value) 
			return ("%.2f"):format(value) 
		end
	):SetPoint('TOPLEFT', sub, 'BOTTOMLEFT', 200, vOfs + vStep * 3)		
end
