local _G = getfenv(0)
local function echo(str) ChatFrame1:AddMessage(str) end 

local CASTBAR_Y = 80
local CASTBAR_OFFSET_Y = 30

SlashCmdList['FRAME'] = function() 
	frame = GetMouseFocus();
	if not frame then return end;
	ChatFrame1:AddMessage(frame:GetName()) 
	point, relativeTo, relativePoint, xOfs, yOfs = frame:GetPoint();
	ChatFrame1:AddMessage('point: '..point)
	if relativeTo then
		ChatFrame1:AddMessage('relativeTo: '..relativeTo:GetName()) 
	end
	ChatFrame1:AddMessage('relativePoint: '..relativePoint) 
	ChatFrame1:AddMessage('xOfs: '..xOfs) 
	ChatFrame1:AddMessage('yOfs: '..yOfs) 
end
SLASH_FRAME1 = '/frame'

local defaults = {
	char = {
		mainBarScale = 1,
		mainBarGryphonsHidden = false,
		
		microMenuHidden = false,
		microMenuLocked = false,
		microMenuScale = 1,
		microMenuPoint = {
			xOfs = 0,
			yOfs = 0,
			point = "CENTER",
			relatedPoint = "CENTER",
			relatedTo = "WorldFrame"
		},

		bagsBarHidden = false,
		bagsBarLocked = false,
		bagsBarScale = 1,
		bagsBarPoint = {
			xOfs = 0,
			yOfs = 0,
			point = "CENTER",
			relatedPoint = "CENTER",
			relatedTo = "WorldFrame"
		},

		petBarHidden = false,
		petBarLocked = false,
		petBarScale = 1,
		petBarPoint = {
			xOfs = 0,
			yOfs = 0,
			point = "CENTER",
			relatedPoint = "CENTER",
			relatedTo = "WorldFrame"
		},

		bonusBarHidden = false,
		bonusBarLocked = false,
		bonusBarScale = 1,
		bonusBarPoint = {
			xOfs = 0,
			yOfs = 0,
			point = "CENTER",
			relatedPoint = "CENTER",
			relatedTo = "WorldFrame"
		}
	}
}

local combatLock = false
local vehicleLock = false

local AceAddon = LibStub("AceAddon-3.0")
SimpleBar = AceAddon:NewAddon("SimpleBar", "AceConsole-3.0", "AceHook-3.0", "AceEvent-3.0");

function SimpleBar:OnInitialize()
	self.db = LibStub("AceDB-3.0"):New("SimpleBarDB", defaults)
	LibStub("LibSimpleOptions-1.0").AddOptionsPanel("SimpleBar", SimpleBar.InitOptions)	
	
	self:SecureHook("UIParent_ManageFramePositions", SimpleBar.UpdateUI)

	self:SecureHook("VehicleMenuBar_MoveMicroButtons", function(skin)
		if not skin then 
			SimpleBar:InitMicromenu()
		end
	end)
		
	SimpleBar:InitBars()
	
	return true
end

function SimpleBar:UpdateUI()
	if InCombatLockdown() then 
		combatLock = true
		return
	else
		combatLock = false
	end	
	
	SimpleBar:UpdateMainMenuBar()
	SimpleBar:UpdateMicromenu()
	SimpleBar:UpdateBagsBar()
	SimpleBar:UpdatePetBar()
	SimpleBar:UpdateBonusBar()
	SimpleBar:UpdateCastbar()
	
	return true
end

function SimpleBar:InitBars()
	if InCombatLockdown() then 
		vehicleLock = true
		return 
	else
		vehicleLock = false
	end	
	
	SimpleBar:InitMainMenuBar()
	SimpleBar:InitMicromenu()
	SimpleBar:InitBagsBar()
	SimpleBar:InitPetBar()
	SimpleBar:InitBonusBar()
end

function SimpleBar:InitMainMenuBar()
	if InCombatLockdown() or UnitHasVehicleUI("player") then return end	
	-- Exp/Rep Bar Textures
	ReputationWatchBarTexture2:SetTexture("")
	ReputationWatchBarTexture3:SetTexture("")
	ReputationXPBarTexture2:SetTexture("")
	ReputationXPBarTexture3:SetTexture("")
	-- MainBar Textures
	MainMenuBarPageNumber:Hide();
	ActionBarUpButton:Hide()
	ActionBarDownButton:Hide()
	MainMenuXPBarTexture2:Hide()
	MainMenuXPBarTexture3:Hide()
	MainMenuBarTexture2:Hide()
	MainMenuBarTexture3:Hide()
	MainMenuMaxLevelBar2:Hide()
	MainMenuMaxLevelBar3:Hide()	
	MainMenuXPBarTexture0:SetPoint("BOTTOM", "MainMenuExpBar", "BOTTOM", -128, 2)
	MainMenuXPBarTexture1:SetPoint("BOTTOM", "MainMenuExpBar", "BOTTOM", 128, 3)
	MainMenuMaxLevelBar0:SetPoint("BOTTOM", "MainMenuBarMaxLevelBar", "TOP", -128, 0)
	MainMenuBarTexture0:SetPoint("BOTTOM", "MainMenuBarArtFrame", "BOTTOM", -128, 0)
	MainMenuBarTexture1:SetPoint("BOTTOM", "MainMenuBarArtFrame", "BOTTOM", 128, 0)
	MainMenuBarLeftEndCap:SetPoint("BOTTOM", "MainMenuBarArtFrame", "BOTTOM", -290, 0)
	MainMenuBarRightEndCap:SetPoint("BOTTOM", "MainMenuBarArtFrame", "BOTTOM", 287, 0)
	-- Resize MainBar
	MainMenuBar:SetWidth(512)
	MainMenuExpBar:SetWidth(512)
	ReputationWatchBar:SetWidth(512)
	MainMenuBarMaxLevelBar:SetWidth(512)
	ReputationWatchStatusBar:SetWidth(512)
	
	SimpleBar:HideGryphons(SimpleBar.db.char.mainBarGryphonsHidden)
	SimpleBar:ScaleMainMenuBar(SimpleBar.db.char.mainBarScale)
end

function SimpleBar:UpdateMainMenuBar()
	if InCombatLockdown() or UnitHasVehicleUI("player") then return end
	if MultiBarBottomRight:IsShown() then
		local yOfs = 0
		if MultiBarBottomLeft:IsShown() then
			yOfs = 42
		end
		MultiBarBottomRight:ClearAllPoints();
		MultiBarBottomRight:SetPoint("BOTTOMLEFT", MultiBarBottomLeft, "BOTTOMLEFT", 0, yOfs);
	end
end

function SimpleBar:UpdateCastbar()
	if InCombatLockdown() or UnitHasVehicleUI("player") then return end
	
	local offset = 0;
	if MultiBarBottomLeft:IsShown() then offset = offset + 1 end
	if MultiBarBottomRight:IsShown() then offset = offset + 1 end
	
	CastingBarFrame:ClearAllPoints();
	CastingBarFrame:SetPoint("CENTER", MainMenuBar, "CENTER", 0, CASTBAR_Y + (CASTBAR_OFFSET_Y * offset))
end

function SimpleBar:HideGryphons(value)
    if (value) then
		MainMenuBarLeftEndCap:Hide();
		MainMenuBarRightEndCap:Hide();
    else
		MainMenuBarLeftEndCap:Show();
		MainMenuBarRightEndCap:Show();	
	end
	SimpleBar.db.char.mainBarGryphonsHidden = value
end

function SimpleBar:ScaleMainMenuBar(value)
	SimpleBar.db.char.mainBarScale = value
	MainMenuBar:SetScale(value)
	MultiBarBottomLeft:SetScale(value)
	MultiBarBottomRight:SetScale(value)
	MultiBarRight:SetScale(value)
	MultiBarLeft:SetScale(value)
end
