local bags = {
	MainMenuBarBackpackButton, 
	CharacterBag0Slot, 
	CharacterBag1Slot,
	CharacterBag2Slot, 
	CharacterBag3Slot, 
	KeyRingButton
}

function SimpleBar:InitBagsBar()
	for i = 1, 6 do
		local b = bags[i]
		b:SetParent(SimpleBar_BagsBar)
	end
	SimpleBar:HideBagsBar(SimpleBar.db.char.bagsBarHidden)
	SimpleBar:LockBagsBar(SimpleBar.db.char.bagsBarLocked)
	SimpleBar:ScaleBagsBar(SimpleBar.db.char.bagsBarScale)
end

function SimpleBar:UpdateBagsBar()
	if UnitHasVehicleUI("player") then return end 
	
	local b = MainMenuBarBackpackButton
	b:ClearAllPoints()
	b:SetPoint("BOTTOMRIGHT", SimpleBar_BagsBar, "BOTTOMRIGHT", -24, 3)	
	local b = KeyRingButton
	b:ClearAllPoints()
	b:SetPoint("BOTTOMRIGHT", SimpleBar_BagsBar, "BOTTOMRIGHT", -2, 2)
	
	SimpleBar_BagsBar:ClearAllPoints()
	SimpleBar_BagsBar:SetPoint(
		self.db.char.bagsBarPoint.point, 
		WorldFrame, 
		self.db.char.bagsBarPoint.relativePoint, 
		self.db.char.bagsBarPoint.xOfs, 
		self.db.char.bagsBarPoint.yOfs
	)		
end

function SimpleBar:HideBagsBar(value)
	if value then
		SimpleBar_BagsBar:Hide()
		--KeyRingButton:Disable();
		--KeyRingButton:DisableDrawLayer();
		--KeyRingButton:Hide();		
	else
		SimpleBar_BagsBar:Show()
		--KeyRingButton:Enable();
		--KeyRingButton:EnableDrawLayer();
		--KeyRingButton:Show();		
	end
	SimpleBar.db.char.bagsBarHidden = value
end

function SimpleBar:LockBagsBar(value)
	if value then
		SimpleBar_BagsBar:SetMovable(false);
		SimpleBar_BagsBar:RegisterForDrag(nil)
		SimpleBar_BagsBar:SetBackdrop({ })
	else
		SimpleBar_BagsBar:SetMovable(true);
		SimpleBar_BagsBar:RegisterForDrag("RightButton")
		SimpleBar_BagsBar:SetBackdrop({ 
			bgFile = "Interface/DialogFrame/UI-DialogBox-Background" 
		})
	end
	SimpleBar.db.char.bagsBarLocked = value
	SimpleBar:UpdateBagsBar()
end

function SimpleBar:ScaleBagsBar(value)
	SimpleBar.db.char.bagsBarScale = value
	SimpleBar_BagsBar:SetScale(value)
end

function SimpleBar_BagsBar_OnDragStart()
	if SimpleBar.db.char.bagsBarLocked then return end
	
	this:StartMoving();
	this.isMoving = true;
end

function SimpleBar_BagsBar_OnDragStop()
	SimpleBar_BagsBar:StopMovingOrSizing();
	SimpleBar_BagsBar.isMoving = false;
	
	point, relativeTo, relativePoint, xOfs, yOfs = SimpleBar_BagsBar:GetPoint()
	
	SimpleBar.db.char.bagsBarPoint.xOfs = xOfs
	SimpleBar.db.char.bagsBarPoint.yOfs = yOfs	
	SimpleBar.db.char.bagsBarPoint.point = point						
	SimpleBar.db.char.bagsBarPoint.relativePoint = relativePoint
end
