	UIPARENT_MANAGED_FRAME_POSITIONS["ShapeshiftBarFrame"] = nil
	UIPARENT_MANAGED_FRAME_POSITIONS["PossessBarFrame"] = nil
	UIPARENT_MANAGED_FRAME_POSITIONS["MultiCastActionBarFrame"] = nil
	
function SimpleBar:InitBonusBar()
	for i = 1, 10 do
		local b = _G["ShapeshiftButton" .. tostring(i)]
		b:SetParent(SimpleBar_BonusBar)
	end
	local b = _G["ShapeshiftButton" .. tostring(1)]
	b:ClearAllPoints()
	b:SetPoint("BOTTOMLEFT", SimpleBar_BonusBar, "BOTTOMLEFT", 6, 8)
	
	for i = 1, 2 do
		local b = _G["PossessButton" .. tostring(i)]
		b:SetParent(SimpleBar_BonusBar)
	end	
	
	MultiCastActionBarFrame:SetParent(SimpleBar_BonusBar)
	MultiCastActionBarFrame:ClearAllPoints()	
	MultiCastActionBarFrame:SetScript("OnShow", nil)
	MultiCastActionBarFrame:SetScript("OnHide", nil)
	MultiCastActionBarFrame:SetScript("OnUpdate", nil)
	MultiCastActionBarFrame:SetPoint("BOTTOMLEFT", SimpleBar_BonusBar, "BOTTOMLEFT", 6, 4)

	ShapeshiftBarFrame:SetWidth(1)
	PossessBarFrame:SetWidth(1)
		
	SimpleBar:HideBonusBar(SimpleBar.db.char.bonusBarHidden)
	SimpleBar:LockBonusBar(SimpleBar.db.char.bonusBarLocked)
	SimpleBar:ScaleBonusBar(SimpleBar.db.char.bonusBarScale)
end

function SimpleBar:UpdateBonusBar()
	if InCombatLockdown() then return end
	
    ShapeshiftBarLeft:Hide()
    ShapeshiftBarMiddle:Hide()
    ShapeshiftBarRight:Hide()
    PossessBackground1:Hide()
    PossessBackground2:Hide()
	
	if UnitHasVehicleUI("player") then return end
	
	local b = _G["ShapeshiftButton" .. tostring(1)]
	b:ClearAllPoints()
	b:SetPoint("BOTTOMLEFT", SimpleBar_BonusBar, "BOTTOMLEFT", 6, 8)	
	local b = _G["PossessButton" .. tostring(1)]
	b:ClearAllPoints()
	b:SetPoint("BOTTOMLEFT", SimpleBar_BonusBar, "BOTTOMLEFT", 6, 8)

	-- local b = _G["MultiCastActionBarFrame"]
	-- b:ClearAllPoints()
	-- b:SetPoint("BOTTOMLEFT", SimpleBar_BonusBar, "BOTTOMLEFT", 6, 8)
	
	SimpleBar_BonusBar:ClearAllPoints()
	SimpleBar_BonusBar:SetPoint(
		self.db.char.bonusBarPoint.point, 
		WorldFrame, 
		self.db.char.bonusBarPoint.relativePoint, 
		self.db.char.bonusBarPoint.xOfs, 
		self.db.char.bonusBarPoint.yOfs
	)
end

function SimpleBar:HideBonusBar(value)
	if value then
		SimpleBar_BonusBar:Hide()
	else
		SimpleBar_BonusBar:Show()
	end
	SimpleBar_BonusBar:EnableMouse(not value)
	SimpleBar.db.char.bonusBarHidden = value
end

function SimpleBar:LockBonusBar(value)
	if value then
		SimpleBar_BonusBar:EnableMouse(false)
		SimpleBar_BonusBar:SetMovable(false)
		SimpleBar_BonusBar:RegisterForDrag(nil)
		SimpleBar_BonusBar:SetBackdrop({ })
	else
		SimpleBar_BonusBar:EnableMouse(true)
		SimpleBar_BonusBar:SetMovable(true);
		SimpleBar_BonusBar:RegisterForDrag("RightButton")
		SimpleBar_BonusBar:SetBackdrop({ 
			bgFile = "Interface/DialogFrame/UI-DialogBox-Background" 
		})
	end
	SimpleBar.db.char.bonusBarLocked = value
	SimpleBar:UpdateBonusBar()
end

function SimpleBar:ScaleBonusBar(value)
	SimpleBar.db.char.bonusBarScale = value
	SimpleBar_BonusBar:SetScale(value)
end

function SimpleBar_BonusBar_OnDragStart()
	if SimpleBar.db.char.bonusBarLocked then return end
	
	this:StartMoving();
	this.isMoving = true;
end

function SimpleBar_BonusBar_OnDragStop()
	SimpleBar_BonusBar:StopMovingOrSizing();
	SimpleBar_BonusBar.isMoving = false;
	
	point, relativeTo, relativePoint, xOfs, yOfs = SimpleBar_BonusBar:GetPoint()
	
	SimpleBar.db.char.bonusBarPoint.xOfs = xOfs
	SimpleBar.db.char.bonusBarPoint.yOfs = yOfs	
	SimpleBar.db.char.bonusBarPoint.point = point						
	SimpleBar.db.char.bonusBarPoint.relativePoint = relativePoint
end
