local micromenu = {
	CharacterMicroButton, 
	SpellbookMicroButton, 
	TalentMicroButton, 
	AchievementMicroButton, 
	QuestLogMicroButton,
	SocialsMicroButton, 
	PVPMicroButton, 
	LFGMicroButton, 
	MainMenuMicroButton, 
	HelpMicroButton
}

function SimpleBar:InitMicromenu()
	for i = 1, 10 do
		local b = micromenu[i]
		b:SetParent(SimpleBar_Micromenu)
	end
	SimpleBar:HideMicromenu(SimpleBar.db.char.microMenuHidden)
	SimpleBar:LockMicromenu(SimpleBar.db.char.microMenuLocked)
	SimpleBar:ScaleMicromenu(SimpleBar.db.char.microMenuScale)
end

function SimpleBar:UpdateMicromenu()
	if UnitHasVehicleUI("player") then return end 
	
	local b = CharacterMicroButton
	b:ClearAllPoints()
	b:SetPoint("BOTTOMLEFT", SimpleBar_Micromenu, "BOTTOMLEFT", 2, 3)
	
	SimpleBar_Micromenu:ClearAllPoints()
	SimpleBar_Micromenu:SetPoint(
		self.db.char.microMenuPoint.point, 
		WorldFrame, 
		self.db.char.microMenuPoint.relativePoint, 
		self.db.char.microMenuPoint.xOfs, 
		self.db.char.microMenuPoint.yOfs
	)		
end

function SimpleBar:InitBags()
	for i = 1, 10 do
		local b = micromenu[i]
		b:SetParent(SimpleBar_Micromenu)
	end
end

function SimpleBar:HideMicromenu(value)
	if value then
		SimpleBar_Micromenu:Hide()
	else
		SimpleBar_Micromenu:Show()
	end
	SimpleBar.db.char.microMenuHidden = value
end

function SimpleBar:LockMicromenu(value)
	if value then
		SimpleBar_Micromenu:SetMovable(false);
		SimpleBar_Micromenu:RegisterForDrag(nil)
		SimpleBar_Micromenu:SetBackdrop({ })
	else
		SimpleBar_Micromenu:SetMovable(true);
		SimpleBar_Micromenu:RegisterForDrag("RightButton")
		SimpleBar_Micromenu:SetBackdrop({ 
			bgFile = "Interface/DialogFrame/UI-DialogBox-Background" 
		})
	end
	SimpleBar.db.char.microMenuLocked = value
	SimpleBar:UpdateMicromenu()
end

function SimpleBar:ScaleMicromenu(value)
	SimpleBar.db.char.microMenuScale = value
	SimpleBar_Micromenu:SetScale(value)
end

function SimpleBar_Micromenu_OnDragStart()
	if SimpleBar.db.char.microMenuLocked then return end
	
	this:StartMoving();
	this.isMoving = true;
end

function SimpleBar_Micromenu_OnDragStop()
	SimpleBar_Micromenu:StopMovingOrSizing();
	SimpleBar_Micromenu.isMoving = false;
	
	point, relativeTo, relativePoint, xOfs, yOfs = SimpleBar_Micromenu:GetPoint()
	
	SimpleBar.db.char.microMenuPoint.xOfs = xOfs
	SimpleBar.db.char.microMenuPoint.yOfs = yOfs	
	SimpleBar.db.char.microMenuPoint.point = point						
	SimpleBar.db.char.microMenuPoint.relativePoint = relativePoint
end
