function SimpleBar:InitPetBar()
	UIPARENT_MANAGED_FRAME_POSITIONS["PetActionBarFrame"] = nil
	PetActionBarFrame:SetAttribute("unit", "pet")
	RegisterUnitWatch(PetActionBarFrame)

	for i = 1, 10 do
		local b = _G["PetActionButton" .. tostring(i)]
		b:SetParent(SimpleBar_PetBar)
	end
	
	PetActionBarFrame:SetWidth(1)
	
	SimpleBar:HidePetBar(SimpleBar.db.char.petBarHidden)
	SimpleBar:LockPetBar(SimpleBar.db.char.petBarLocked)
	SimpleBar:ScalePetBar(SimpleBar.db.char.petBarScale)
end

function SimpleBar:UpdatePetBar()
	if InCombatLockdown() then return end
	
	SlidingActionBarTexture0:Hide()
	SlidingActionBarTexture1:Hide()
	
	if UnitHasVehicleUI("player") then return end
	
	local b = _G["PetActionButton" .. tostring(1)]
	b:ClearAllPoints()
	b:SetPoint("BOTTOMLEFT", SimpleBar_PetBar, "BOTTOMLEFT", 6, 8)	
	
	SimpleBar_PetBar:ClearAllPoints()
	SimpleBar_PetBar:SetPoint(
		self.db.char.petBarPoint.point, 
		WorldFrame, 
		self.db.char.petBarPoint.relativePoint, 
		self.db.char.petBarPoint.xOfs, 
		self.db.char.petBarPoint.yOfs
	)		
end

function SimpleBar:HidePetBar(value)
	if value then
		SimpleBar_PetBar:Hide()
	else
		SimpleBar_PetBar:Show()
	end
	SimpleBar_PetBar:EnableMouse(not value)
	SimpleBar.db.char.petBarHidden = value
end

function SimpleBar:LockPetBar(value)
	if value then
		SimpleBar_PetBar:EnableMouse(false)
		SimpleBar_PetBar:SetMovable(false)
		SimpleBar_PetBar:RegisterForDrag(nil)
		SimpleBar_PetBar:SetBackdrop({ })
	else
		SimpleBar_PetBar:EnableMouse(true)
		SimpleBar_PetBar:SetMovable(true);
		SimpleBar_PetBar:RegisterForDrag("RightButton")
		SimpleBar_PetBar:SetBackdrop({ 
			bgFile = "Interface/DialogFrame/UI-DialogBox-Background" 
		})
	end
	SimpleBar.db.char.petBarLocked = value
	SimpleBar:UpdatePetBar()
end

function SimpleBar:ScalePetBar(value)
	SimpleBar.db.char.petBarScale = value
	SimpleBar_PetBar:SetScale(value)
end

function SimpleBar_PetBar_OnDragStart()
	if SimpleBar.db.char.petBarLocked then return end
	
	this:StartMoving();
	this.isMoving = true;
end

function SimpleBar_PetBar_OnDragStop()
	SimpleBar_PetBar:StopMovingOrSizing();
	SimpleBar_PetBar.isMoving = false;
	
	point, relativeTo, relativePoint, xOfs, yOfs = SimpleBar_PetBar:GetPoint()
	
	SimpleBar.db.char.petBarPoint.xOfs = xOfs
	SimpleBar.db.char.petBarPoint.yOfs = yOfs	
	SimpleBar.db.char.petBarPoint.point = point						
	SimpleBar.db.char.petBarPoint.relativePoint = relativePoint
end
